// ==UserScript==
// @name         5ch Force Dark Mode (Optimized)
// @namespace    https://example.com/your-namespace
// @version      1.0
// @description  強制的に5chのスレッドページをダークモードにします
// @author       YourName
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// @run-at       document-start
// ==/UserScript==

(function () {

    const style = document.createElement('style');
    style.textContent = `
        /* ルートにダークモード用のCSS変数を定義 */
        :root {
            --bg-dark: #212425;           /* 背景色: ダークモード */
            --bg-darker: #1e1e1e;         /* 背景色: さらに暗いモード */
            --bg-darkest: #1a1a1a;        /* 背景色: 最も暗いモード */
            --text-main: #e0e0e0;         /* 文字色: 明るい灰色 */
            --text-muted: #aabbcc;        /* ミュートされた文字色: 薄い灰色 */
            --text-link: #80cbc4;         /* リンク色 */
            --text-link-hover: #a7ffeb;   /* リンクホバー時の色 */
            --border-color: #333;         /* ボーダー色: ダークグレー */
            --white: #ffffff;             /* 白色 */
        }

        /* 基本の背景色と文字色を設定 (body, スレッド、投稿など) */
        body, #threadcontent,
        .post, .postbody, .thread, .container, .header, .footer {
            background-color: var(--bg-dark) !important;
            color: var(--text-main) !important;
        }

        /* 投稿ヘッダー内の文字色 */
        .post-header,
        .post-header a,
        .post-header b,
        .post-header span {
            color: var(--text-muted) !important;
        }

        /* 投稿内容や「clear post」の文字色 */
        .post-content,
        .clear.post {
            color: var(--text-main) !important;
        }

        /* リンクのカラー */
        a {
            color: var(--text-link) !important;
        }

        /* テーブルのスタイル (背景色、文字色、ボーダー) */
        table, td, th {
            background-color: var(--bg-darker) !important;
            color: #ccc !important;
            border-color: var(--border-color) !important;
        }

        /* 左右のオーバーレイ部分 (#overleft, #overright) */
        #overleft, #overright {
            background-color: var(--bg-darkest) !important;
            color: var(--text-main) !important;
            border: 1px solid var(--border-color) !important;
            padding: 10px !important;
            border-radius: 4px !important;
        }

        /* オーバーレイの太文字部分のスタイル */
        #overleft .bold,
        #overright .bold {
            font-weight: bold !important;
            color: var(--white) !important;
        }

        /* オーバーレイのリストスタイル */
        #overleft ul,
        #overright ul {
            padding-left: 0 !important;
        }

        /* リストアイテムのスタイル */
        #overleft ul.p85.slightpad.nobullets li,
        #overright ul.p85.slightpad.nobullets li {
            background-color: var(--bg-darker) !important;
            color: var(--text-main) !important;
            margin: 5px 0 !important;
            padding: 6px 10px !important;
            border-radius: 3px !important;
            list-style: none !important;
        }

        /* リストアイテム内のリンク */
        #overleft ul.p85.slightpad.nobullets li a,
        #overright ul.p85.slightpad.nobullets li a {
            color: var(--text-link) !important;
            text-decoration: none !important;
        }

        /* リストアイテム内のリンクのホバー時のスタイル */
        #overleft ul.p85.slightpad.nobullets li a:hover,
        #overright ul.p85.slightpad.nobullets li a:hover {
            color: var(--text-link-hover) !important;
            text-decoration: underline !important;
        }

        /* ポップアップのスタイル (レス番号ポップアップ) */
        .post_hover {
            background-color: var(--bg-darkest) !important;  /* ダーク背景 */
            color: var(--text-main) !important;              /* 明るい文字色 */
            border: 1px solid var(--border-color) !important; /* ダークなボーダー */
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.3) !important; /* 影を追加 */
        }

        /* ポップアップ内のヘッダー部分のスタイル */
        .post_hover .post-header {
            background-color: #333 !important;  /* ヘッダー背景色 */
            color: var(--text-main) !important;  /* ヘッダー文字色 */
        }

        /* ポップアップ内のリンク */
        .post_hover .post-header a {
            color: var(--text-link) !important;  /* リンク色 */
        }

        /* リンクホバー時のカラー */
        .post_hover .post-header a:hover {
            color: var(--text-link-hover) !important; /* ホバー時リンク色 */
        }

        /* ポップアップ内の投稿内容 */
        .post_hover .post-content {
            color: var(--text-main) !important; /* 投稿内容文字色 */
        }

        /* 投稿者名のスタイル */
        .post_hover .postusername {
            color: var(--text-link) !important;  /* ユーザー名のリンク色 */
        }

        /* ■ レス数が900を超えています。1000を超えると表示できなくなるよ。 の色 */
        .stoplight.stopyellow {
            background-color: #4a1a1a !important;  /* ダークレッドっぽい背景 */
            color: #f8d7da !important;             /* 薄いピンク系の文字色 */
            border: 1px solid #721c24 !important;  /* 枠線もダークレッドに */
            padding: 8px 12px !important;
            border-radius: 4px !important;
        }

        /* ■ このスレッドは過去ログ倉庫に格納されています の色 */
        .stoplight.stopred {
            background-color: #4a1a1a !important;  /* ダークレッドっぽい背景 */
            color: #f8d7da !important;             /* 薄いピンク系の文字色 */
            border: 1px solid #721c24 !important;  /* 枠線もダークレッドに */
            padding: 8px 12px !important;
            border-radius: 4px !important;
        }
    `;
    document.head.appendChild(style);
})();
